/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.sdgraph;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AtomicDouble;
import cz.insophy.inplan.sdgraph.AbstractSdgNode;
import cz.insophy.inplan.sdgraph.SdgEdge;
import cz.insophy.inplan.sdgraph.SdgNodeVisitor;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class SdgGorNode
extends AbstractSdgNode {
    private final GeneralizedOrderRequest gor;

    SdgGorNode(GeneralizedOrderRequest gor) {
        this.gor = gor;
    }

    public GeneralizedOrderRequest getGor() {
        return this.gor;
    }

    public String toString() {
        return "SdgGorNode{gor=" + this.gor + "}";
    }

    @Override
    public <T> T accept(SdgNodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public long getMatprodPreparedTime(@Nonnull GeneralizedActionRequest gar) {
        Preconditions.checkNotNull(gar, "GAR cannot be null");
        Preconditions.checkArgument(gar.getParent() == this.gor, "GAR must belong to GOR of this SdgGorNode");
        long matprodPreparedTime = Long.MIN_VALUE;
        HashMap<Material, AtomicDouble> reqMats = new HashMap<Material, AtomicDouble>();
        double q = gar.getRequestedQty() - gar.getOutOfPlanMat();
        for (MaterialQuantity mq : gar.getAction().getBom()) {
            if (!mq.getMaterial().isConsumed()) continue;
            AtomicDouble d = reqMats.computeIfAbsent(mq.getMaterial(), material -> new AtomicDouble());
            d.addAndGet((mq.getMaterial().isConstant() ? 1.0 : q) * mq.getQty());
        }
        for (SdgEdge edge : this.getIncomingEdges()) {
            StoreActivity destSa = edge.getDestinationStoreActivity();
            Preconditions.checkState(destSa != null, "unexpected edge with null SA");
            if (destSa.getOriginator() != gar) continue;
            if (edge.getStartTime() > matprodPreparedTime) {
                matprodPreparedTime = edge.getStartTime();
            }
            ((AtomicDouble)reqMats.get(destSa.getMaterial())).addAndGet(-edge.getQty());
        }
        boolean completelyFed = true;
        for (Map.Entry entry : reqMats.entrySet()) {
            if (!(((AtomicDouble)entry.getValue()).doubleValue() > 1.0E-7)) continue;
            completelyFed = false;
            break;
        }
        return completelyFed ? matprodPreparedTime : Long.MAX_VALUE;
    }
}

